<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 15.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Dienstposten');
requireLogin();
requireRole(['Bearbeiter', 'Administrator']);

// Überprüft, ob ein Session-Alert vorhanden ist, und zeigt ihn an
showSessionAlert();

// Dienstpostenübergabe
if (isset($_POST['handoverPosition'])) {

    initializeDatabaseConnection();

    $sql = "SELECT * FROM Positions WHERE ID = :ID";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':ID', $_POST['positionID']);
    $stmt->execute();

    $getPositionDetail = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($getPositionDetail['Successor'] != NULL) {

        // Identität (Vorgänger) : Dienstposten Entfernen
        updateIdenty($getPositionDetail['Owner'], 'AccessCard', NULL);
        // Identität (Nachfolger) : Dienstposten Hinzufügen
        updateIdenty($getPositionDetail['Successor'], 'AccessCard', $getPositionDetail['OwnerAccessCard']);

        // Dienstposten : Eintragen von Vorgänger zum Nachfolger und Entfernen des alten
        updatePosition($getPositionDetail['ID'], 'Owner', $getPositionDetail['Successor']);
        updatePosition($getPositionDetail['ID'], 'Successor', NULL);

        // AuditLog: Eintrag erstellen
        addAuditLog($_SESSION['Username'], 'Dienstposten', 'Dienstposten "' . $getPositionDetail['ID'] . ' - ' . getPositionDetails("ID", $getPositionDetail['ID'], 'PositionName') . '" übergeben');

        // Erstellt einen Session-Alert 
        createSessionAlert("", "Dienstposten <h4 class='pt-2 pb-2'>" . getPositionDetails("ID", $_POST['positionID'], 'PositionName') . "</h4> wurde erfolgreich übergeben", "success", "false", "2000");

        // Verhindert das erneute Absenden des Formulars
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit();
    }

}

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<div class="row">

    <div class="position-absolute start-0 end-0">

        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
                <div>
                    <h4 class="mb-md-0">Dienstposten</h4>
                    <span class="text-secondary">Liste</span>
                </div>
                <div class="d-flex align-items-center flex-wrap text-nowrap">

                    <div class="dropdown">
                        <button class="btn btn-primary dropdown-toggle btn-icon-text me-2" type="button"
                            id="dropdownMenuButton" data-bs-toggle="dropdown" aria-haspopup="true"
                            aria-expanded="false">
                            <i class="btn-icon-prepend mdi mdi-briefcase-plus"></i> Neu
                        </button>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="/identities/add-position-military">Militärisch</a>
                            <a class="dropdown-item" href="/identities/add-position-civil">Zivil</a>
                            <a class="dropdown-item" href="/identities/add-position-local">Ortskräfte</a>
                            <a class="dropdown-item" href="/identities/add-position-guest">Gäste</a>
                        </div>
                    </div>

                    <div class="dropdown" data-bs-toggle="tooltip" data-bs-placement="top" title="Exportieren">
                        <button class="btn btn-success btn-icon me-2" type="button" id="dropdownMenuButton"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="mdi mdi-download"></i>
                        </button>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="#">PDF <span style="margin-left:15px;font-size:10px;"
                                    class="text-warning">NICHT VERFÜGBAR</span></a>
                            <a class="dropdown-item" href="#">EXCEL <span style="margin-left:15px;font-size:10px;"
                                    class="text-warning">NICHT VERFÜGBAR</span></a>
                        </div>
                    </div>

                    <a href="/identities/identitiesboard" class="btn btn-secondary btn-icon mb-md-0"
                        data-bs-toggle="tooltip" data-bs-placement="top" title="Zurück">
                        <i class="mdi mdi-arrow-left-top"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="col-12 col-md-12 col-xl-12 grid-margin">
            <div class="card">

                <div class="card-header">

                    <ul class="nav nav-tabs card-header-tabs" id="lineTab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="home-line-tab" data-bs-toggle="tab"
                                href="#positions-military" role="tab" aria-controls="Militärisch"
                                aria-selected="true">Militärisch</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="profile-line-tab" data-bs-toggle="tab" href="#positions-civil"
                                role="tab" aria-controls="Zivil" aria-selected="false">Zivil</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="contact-line-tab" data-bs-toggle="tab" href="#positions-local"
                                role="tab" aria-controls="Ortskräfte" aria-selected="false">Ortskräfte</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="contact-line-tab" data-bs-toggle="tab" href="#positions-guests"
                                role="tab" aria-controls="Gäste" aria-selected="false">Gäste</a>
                        </li>
                    </ul>
                </div>
                <div class="card-body">

                    <div class="tab-content" id="lineTabContent">

                        <div class="tab-pane show active" id="positions-military" role="tabpanel"
                            aria-labelledby="home-line-tab">

                            <div class="table-responsive">

                                <table id="dTablePosMilitary" width="100%" class="table" style="text-align: left;">
                                    <thead>
                                        <tr>
                                            <th class="text-start"><i class="mdi mdi-music-accidental-sharp"
                                                    style="margin-right: .5rem;"></i>ID</th>
                                            <th class="text-start"><i class="mdi mdi-briefcase"
                                                    style="margin-right: .5rem;"></i> Bezeichnung</th>
                                            <th class="text-start"><i class="mdi mdi-sitemap"
                                                    style="margin-right: .5rem;"></i> Dienststelle</th>
                                            <th class="text-start"><i class="mdi mdi-account"
                                                    style="margin-right: .5rem;"></i> Identität</th>
                                            <th class="text-start"><i class="mdi mdi-account-arrow-left"
                                                    style="margin-right: .5rem;"></i> Nachfolger</th>
                                            <th><i class="mdi mdi-button-cursor" style="margin-right: .5rem;"></i>
                                                Optionen
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php

                                        initializeDatabaseConnection();

                                        $sql = "SELECT * FROM Positions WHERE Type = 'Military'";
                                        $stmt = $pdo->query($sql);
                                        $Positions = $stmt->fetchAll();

                                        if ($Positions) {
                                            foreach ($Positions as $Position) {

                                                echo "<tr>";
                                                echo "<td class='text-start'><a href='/identities/position?id=" . htmlspecialchars($Position['ID']) . "' class='btn btn-sm btn-light fw-bold'>" . htmlspecialchars($Position['ID']) . "</a></td>";
                                                echo "<td class='text-start fw-bold'>" . htmlspecialchars($Position['PositionName']) . "</td>";
                                                echo "<td class='text-start fw-bold'>" . htmlspecialchars($Position['Department']) . "</td>";

                                                echo "<td class='text-start'>";
                                                echo "<span class='btn btn-sm btn-outline-secondary me-2'><i class='btn-icon-prepend mdi mdi-credit-card-outline me-1'></i>" . $Position['OwnerAccessCard'] . "</span>";
                                                if ($Position['Owner']) {
                                                    echo "<a href='/identities/identity?id=" . htmlspecialchars($Position['Owner']) . "' class='btn btn-sm btn-light fw-bold'>" . getIdentityDetails($Position['Owner'], 'Rank') . " " . getIdentityDetails($Position['Owner'], 'Surname') . ", " . getIdentityDetails($Position['Owner'], 'Givenname') . "</a>";
                                                } else {
                                                    echo "<span class='btn btn-sm btn-outline-warning'>Unbesetzt</span>";
                                                }
                                                echo "</td>";

                                                echo "<td class='text-start'>";
                                                echo "<span class='btn btn-sm btn-outline-secondary me-2'><i class='btn-icon-prepend mdi mdi-credit-card-outline me-1'></i>" . $Position['SuccessorAccessCard'] . "</span>";
                                                if ($Position['Successor']) {
                                                    echo "<a href='/identities/identity?id=" . htmlspecialchars($Position['Successor']) . "' class='btn btn-sm btn-light fw-bold'>" . getIdentityDetails($Position['Successor'], 'Rank') . " " . getIdentityDetails($Position['Successor'], 'Surname') . ", " . getIdentityDetails($Position['Successor'], 'Givenname') . "</a>";
                                                }
                                                echo "</td>";

                                                echo "<td class='text-end'><form action='' method='post' class='p-0 m-0'>";
                                                if ($Position['Successor']) {
                                                    echo "<input type='hidden' name='positionID' value='" . htmlspecialchars($Position['ID']) . "'><button class='btn btn-sm btn-success me-2' name='handoverPosition'><i class='mdi mdi-handshake btn-icon-prepend'></i> Übergeben</button>";
                                                }
                                                echo "<a href='/identities/position?id=" . htmlspecialchars($Position['ID']) . "' class='btn btn-sm btn-inverse-light btn-icon-text'><i class='mdi mdi-text-box-edit'></i> Bearbeiten</a>";
                                                echo "</form></td>";

                                                echo "</tr>";
                                            }
                                        }

                                        ?>

                                    </tbody>
                                </table>

                            </div>
                        </div>

                        <div class="tab-pane" id="positions-civil" role="tabpanel" aria-labelledby="profile-line-tab">

                            <div class="table-responsive">

                                <table id="dTablePosCivil" width="100%" class="table" style="text-align: left;">
                                    <thead>
                                        <tr>
                                            <th class="text-start"><i class="mdi mdi-music-accidental-sharp"
                                                    style="margin-right: .5rem;"></i>ID</th>
                                            <th class="text-start"><i class="mdi mdi-briefcase"
                                                    style="margin-right: .5rem;"></i> Bezeichnung</th>
                                            <th class="text-start"><i class="mdi mdi-sitemap"
                                                    style="margin-right: .5rem;"></i> Dienststelle</th>
                                            <th class="text-start"><i class="mdi mdi-account"
                                                    style="margin-right: .5rem;"></i> Identität</th>
                                            <th class="text-start"><i class="mdi mdi-account-arrow-left"
                                                    style="margin-right: .5rem;"></i> Nachfolger</th>
                                            <th><i class="mdi mdi-button-cursor" style="margin-right: .5rem;"></i>
                                                Optionen
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php

                                        initializeDatabaseConnection();

                                        $sql = "SELECT * FROM Positions WHERE Type = 'Civil'";
                                        $stmt = $pdo->query($sql);
                                        $Positions = $stmt->fetchAll();

                                        if ($Positions) {
                                            foreach ($Positions as $Position) {

                                                echo "<tr>";
                                                echo "<td class='text-start'><a href='/identities/position?id=" . htmlspecialchars($Position['ID']) . "' class='btn btn-sm btn-light fw-bold'>" . htmlspecialchars($Position['ID']) . "</a></td>";
                                                echo "<td class='text-start fw-bold'>" . htmlspecialchars($Position['PositionName']) . "</td>";
                                                echo "<td class='text-start fw-bold'>" . htmlspecialchars($Position['Department']) . "</td>";

                                                echo "<td class='text-start'>";
                                                echo "<span class='btn btn-sm btn-outline-secondary me-2'><i class='btn-icon-prepend mdi mdi-credit-card-outline me-1'></i>" . $Position['OwnerAccessCard'] . "</span>";
                                                if ($Position['Owner']) {
                                                    echo "<a href='/identities/identity?id=" . htmlspecialchars($Position['Owner']) . "' class='btn btn-sm btn-light fw-bold'>" . getIdentityDetails($Position['Owner'], 'Rank') . " " . getIdentityDetails($Position['Owner'], 'Surname') . ", " . getIdentityDetails($Position['Owner'], 'Givenname') . "</a>";
                                                } else {
                                                    echo "<span class='btn btn-sm btn-outline-warning'>Unbesetzt</span>";
                                                }
                                                echo "</td>";

                                                echo "<td class='text-start'>";
                                                echo "<span class='btn btn-sm btn-outline-secondary me-2'><i class='btn-icon-prepend mdi mdi-credit-card-outline me-1'></i>" . $Position['SuccessorAccessCard'] . "</span>";
                                                if ($Position['Successor']) {
                                                    echo "<a href='/identities/identity?id=" . htmlspecialchars($Position['Successor']) . "' class='btn btn-sm btn-light fw-bold'>" . getIdentityDetails($Position['Successor'], 'Rank') . " " . getIdentityDetails($Position['Successor'], 'Surname') . ", " . getIdentityDetails($Position['Successor'], 'Givenname') . "</a>";
                                                }
                                                echo "</td>";

                                                echo "<td class='text-end'><form action='' method='post' class='p-0 m-0'>";
                                                if ($Position['Successor']) {
                                                    echo "<input type='hidden' name='positionID' value='" . htmlspecialchars($Position['ID']) . "'><button class='btn btn-sm btn-success me-2' name='handoverPosition'><i class='mdi mdi-handshake btn-icon-prepend'></i> Übergeben</button>";
                                                }
                                                echo "<a href='/identities/position?id=" . htmlspecialchars($Position['ID']) . "' class='btn btn-sm btn-inverse-light btn-icon-text'><i class='mdi mdi-text-box-edit'></i> Bearbeiten</a>";
                                                echo "</form></td>";

                                                echo "</tr>";
                                            }
                                        }

                                        ?>

                                    </tbody>
                                </table>

                            </div>

                        </div>

                        <div class="tab-pane" id="positions-local" role="tabpanel" aria-labelledby="contact-line-tab">

                            <div class="table-responsive">
                                <table id="dTablePosLocal" width="100%" class="table" style="text-align: left;">
                                    <thead>
                                        <tr>
                                            <th class="text-start"><i class="mdi mdi-music-accidental-sharp"
                                                    style="margin-right: .5rem;"></i>ID</th>
                                            <th class="text-start"><i class="mdi mdi-briefcase"
                                                    style="margin-right: .5rem;"></i> Bezeichnung</th>
                                            <th class="text-start"><i class="mdi mdi-sitemap"
                                                    style="margin-right: .5rem;"></i> Arbeitsbereich</th>
                                            <th class="text-start"><i class="mdi mdi-account"
                                                    style="margin-right: .5rem;"></i> Identität</th>
                                            <th><i class="mdi mdi-button-cursor" style="margin-right: .5rem;"></i>
                                                Optionen
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php
                                        initializeDatabaseConnection();
                                        $sql = "SELECT * FROM Positions WHERE Type = 'Local'";
                                        $stmt = $pdo->query($sql);
                                        $Positions = $stmt->fetchAll();

                                        if ($Positions) {
                                            foreach ($Positions as $Position) {

                                                echo "<tr>";
                                                echo "<td class='text-start'><a href='/identities/position?id=" . htmlspecialchars($Position['ID']) . "' class='btn btn-sm btn-light fw-bold'>" . htmlspecialchars($Position['ID']) . "</a></td>";
                                                echo "<td class='text-start fw-bold'>" . htmlspecialchars($Position['PositionName']) . "</td>";
                                                echo "<td class='text-start fw-bold'>" . htmlspecialchars($Position['Department']) . "</td>";

                                                echo "<td class='text-start'>";
                                                echo "<span class='btn btn-sm btn-outline-secondary me-2'><i class='btn-icon-prepend mdi mdi-credit-card-outline me-1'></i>" . $Position['OwnerAccessCard'] . "</span>";
                                                if ($Position['Owner']) {
                                                    echo "<a href='/identities/identity?id=" . htmlspecialchars($Position['Owner']) . "' class='btn btn-sm btn-light fw-bold'>" . getIdentityDetails($Position['Owner'], 'Rank') . " " . getIdentityDetails($Position['Owner'], 'Surname') . ", " . getIdentityDetails($Position['Owner'], 'Givenname') . "</a>";
                                                } else {
                                                    echo "<span class='btn btn-sm btn-outline-warning'>Unbesetzt</span>";
                                                }
                                                echo "</td>";

                                                echo "<td class='text-end'><a href='/identities/position?id=" . htmlspecialchars($Position['ID']) . "' class='btn btn-sm btn-inverse-light btn-icon-text'><i class='mdi mdi-text-box-edit'></i> Bearbeiten</a></td>";
                                                echo "</tr>";
                                            }
                                        }

                                        ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>


                        <div class="tab-pane" id="positions-guests" role="tabpanel" aria-labelledby="profile-line-tab">
                            <div class="table-responsive">
                                <table id="dTablePosGuests" width="100%" class="table" style="text-align: left;">
                                    <thead>
                                        <tr>
                                            <th class="text-start"><i class="mdi mdi-music-accidental-sharp"
                                                    style="margin-right: .5rem;"></i>ID</th>
                                            <th class="text-start"><i class="mdi mdi-briefcase"
                                                    style="margin-right: .5rem;"></i> Bezeichnung</th>
                                            <th class="text-start"><i class="mdi mdi-sitemap"
                                                    style="margin-right: .5rem;"></i> Arbeitsbereich</th>
                                            <th class="text-start"><i class="mdi mdi-account"
                                                    style="margin-right: .5rem;"></i> Identität</th>
                                            <th><i class="mdi mdi-button-cursor" style="margin-right: .5rem;"></i>
                                                Optionen
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php
                                        initializeDatabaseConnection();
                                        $sql = "SELECT * FROM Positions WHERE Type = 'Guest'";
                                        $stmt = $pdo->query($sql);
                                        $Positions = $stmt->fetchAll();

                                        if ($Positions) {
                                            foreach ($Positions as $Position) {

                                                echo "<tr>";
                                                echo "<td class='text-start'><a href='/identities/position?id=" . htmlspecialchars($Position['ID']) . "' class='btn btn-sm btn-light fw-bold'>" . htmlspecialchars($Position['ID']) . "</a></td>";
                                                echo "<td class='text-start fw-bold'>" . htmlspecialchars($Position['PositionName']) . "</td>";
                                                echo "<td class='text-start fw-bold'>" . htmlspecialchars($Position['Department']) . "</td>";

                                                echo "<td class='text-start'>";
                                                echo "<span class='btn btn-sm btn-outline-secondary me-2'><i class='btn-icon-prepend mdi mdi-credit-card-outline me-1'></i>" . $Position['OwnerAccessCard'] . "</span>";
                                                if ($Position['Owner']) {
                                                    echo "<a href='/identities/identity?id=" . htmlspecialchars($Position['Owner']) . "' class='btn btn-sm btn-light fw-bold'>" . getIdentityDetails($Position['Owner'], 'Rank') . " " . getIdentityDetails($Position['Owner'], 'Surname') . ", " . getIdentityDetails($Position['Owner'], 'Givenname') . "</a>";
                                                } else {
                                                    echo "<span class='btn btn-sm btn-outline-warning'>Unbesetzt</span>";
                                                }
                                                echo "</td>";

                                                echo "<td class='text-end'><a href='/identities/position?id=" . htmlspecialchars($Position['ID']) . "' class='btn btn-sm btn-inverse-light btn-icon-text'><i class='mdi mdi-text-box-edit'></i> Bearbeiten</a></td>";
                                                echo "</tr>";
                                            }
                                        }

                                        ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </div>

</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Letzten aktiven Tab aus dem Local Storage laden
        var possitionsActiveTab = localStorage.getItem('possitionsActiveTab');

        if (possitionsActiveTab) {
            var tabTrigger = new bootstrap.Tab(document.querySelector('a[href="' + possitionsActiveTab + '"]'));
            tabTrigger.show();
        }

        // Event Listener für Tab Wechsel hinzufügen und im Local Storage speichern
        var tabLinks = document.querySelectorAll('a[data-bs-toggle="tab"]');
        tabLinks.forEach(function (tab) {
            tab.addEventListener('shown.bs.tab', function (event) {
                localStorage.setItem('possitionsActiveTab', event.target.getAttribute('href'));
            });
        });
    });
</script>